// UPhoneMatch.cp
// UPhoneMatch.h
// ----------------------------------------------------------------------------------
// Phonetic matcher for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// This matches two phonemes.  You have the character position of a phoneme
// in a string and then the number of the phoneme.  ie. is it the first
// phoneme, or the second one in the string.  In other words the class 
// converts a string into a 'phonetical string' rather than a character
// string.  This is then compared.
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Fixed it up slightly.  Nothing major
// ----------------------------------------------------------------------------------


#ifndef _UPhoneMatch_
#define _UPhoneMatch_

#include "Tspell.h"

// Was 128
#define WORDFILTERSIZE (1024)

class UPhoneMatch {
public:
	UPhoneMatch();

	// the phonemes
	int P_B, P_CH, P_D, P_F, P_G, P_H, P_J, P_K, P_L, P_M, P_N, P_P,
	P_R, P_S, P_SH, P_T, P_TS, P_V, P_W, P_Z, P_VWL, P_Ve, P_Vet,
	P_EOW;

	void Insert(short Phoneme, short Position);
	short  Check(short Phoneme, short Position);
	void Reset();

private:

	char *WordFilter;
	long Hash(long Num1, long Num2);
	char WordFilterBuffer[WORDFILTERSIZE];

}; // UPhoneMatch

#endif

